CREATE TABLE IF NOT EXISTS `a00_change_log` (
`v00_code`  varchar(30) NOT NULL ,
`v00_description`  varchar(200) NULL ,
`d00_timestamp`  timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (`v00_code`)
)
;

insert into a00_change_log values('20140623 http file proxy.sql','Tabella per server Http File Proxy (ADT)', now());




CREATE TABLE `t000_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `v_source` varchar(50) NOT NULL COMMENT 'Sorgente errore',
  `v_message` text NOT NULL,
  `v_stacktrace` text,
  `n_ticket` int(11) DEFAULT NULL,
  `d_record` datetime NOT NULL COMMENT 'Timestamp aggiornamento record',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tracciamento eccezioni gravi del server';


CREATE TABLE `t001_config_properties` (
  `v_key` varchar(50) NOT NULL,
  `v_value` varchar(256) NOT NULL,
  `v_description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`v_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE `t005_cluster_info` (
  `v_hostname` varchar(100) NOT NULL,
  `v_context` varchar(100) NOT NULL DEFAULT '/',
  `v_address` varchar(20) DEFAULT NULL,
  `v_backplane_hostname` varchar(100) DEFAULT NULL COMMENT 'Indirizzo privato alla rete',
  `d_life_start` datetime NOT NULL COMMENT 'Inizio sessione di vita',
  `d_life_stop` datetime DEFAULT NULL,
  `d_last_beat` datetime NOT NULL COMMENT 'Ultimo "battito"',
  `f_do_not_use` tinyint(1) NOT NULL DEFAULT '0',
  `v_version` varchar(50) DEFAULT NULL,
  `d_record` datetime NOT NULL COMMENT 'Timestamp aggiornamento record',
  PRIMARY KEY (`v_hostname`,`v_context`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Autorilevamento cluster attivi';



INSERT INTO `t001_config_properties` (`v_key`, `v_value`, `v_description`) VALUES ('haertbeat.delay', '0', 'Heartbeat verso server master');
INSERT INTO `t001_config_properties` (`v_key`, `v_value`, `v_description`) VALUES ('resource.root', '/var/www/web77/DATA/adt/101/ftp', 'Root dei file');


